% PCA analysis of the US real yields

% load data

clear all

cd('../Prog/PCA analysis of real yields')

load('data.mat')

[coeff,score,latent,tsquared,explained,mu] = pca(data);

for i = 1:4
stdev(i) = (sum((data(:,i) - mean(data(:,i))).^2) / (length(data(:,i)-1)))^0.5;
end 

mvaPC1 = score(:,1) / mean(stdev) + +mean(mu);

years = 1980:1:2018;

figure1 = figure('units','centimeters','outerposition',[10 10 25 12]);
subplot(1,2,1)
plot(years, data, 'linewidth',1.5)
legend('S\&P500 real earnings yield','Real Aaa Corporate Bond yield','Real Baa Corporate Bond yield','Real 10-year Treasury yield','location','northeast')
legend('boxoff')
ylabel('Percent')
title('Real returns on US assets')
subplot(1,2,2)
plot(years, score(:,1), 'r', 'linewidth', 1.5);
hold on
plot(years, score(:,2), 'b', 'linewidth', 1.5);
legend('First PC: 94\% of variance explained','Second PC: 5\% of variance explained','location','northeast')
legend('boxoff')
ylabel('Mean-zero principal components')
title('Principal components')



set(gcf, 'Color', 'w');
export_fig 'Real_yields_PCA'.pdf 